//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.2

import wesual.Controls 1.0

Item {
    id : commandLink

    property alias text             : linkText.text
    property alias font             : linkText.font
    property bool  addWidthMargin   : true

    readonly property int widthMargin : addWidthMargin ? 4 : 0

    signal clicked()

    implicitWidth    : Math.ceil(linkText.implicitWidth)  + widthMargin
    implicitHeight   : Math.ceil(linkText.implicitHeight) + 5

    activeFocusOnTab : true

    Rectangle {
        id : focusBorder

        width : parent.width
        height : parent.height
        border {
            width : 1
            color : UI.color(UI.PrimaryFocusBorder, 0.4)
        }
        color : UI.color(UI.PrimaryFocusBorder, 0.2)
        visible : parent.activeFocus
    }

    Text {
        id : linkText

        anchors.horizontalCenter : parent.horizontalCenter
        font {
            family : UI.fontFamily(UI.SecondaryFont)
            weight : UI.fontWeight(UI.SecondaryFont)
            pixelSize : 14
        }
        wrapMode : Text.Wrap
        color : mouseArea.pressed ?
                    UI.color(UI.LinkPressColor) : UI.color(UI.LinkBaseColor)

        Behavior on color {
            ColorAnimation { duration : 0 }
        }
    }

    Rectangle {
        anchors {
            top : linkText.bottom
            topMargin: 1
            horizontalCenter : parent.horizontalCenter
        }
        height : 2
        width  : parent.width - widthMargin
        color  : UI.color(UI.LinkLineColor)
        visible : mouseArea.containsMouse || parent.activeFocus
    }

    MouseArea {
        id : mouseArea
        anchors.fill : parent
        cursorShape  : Qt.PointingHandCursor
        hoverEnabled : true

        onClicked : commandLink.clicked()
    }

//    states : [
//        State {
//            name : "hovered"
//            when : mouseArea.containsMouse
//        }
//    ]

    Keys.onReturnPressed : commandLink.clicked()
    Keys.onEnterPressed  : commandLink.clicked()
    Keys.onSpacePressed  : commandLink.clicked()
}
